/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ce.casehandlers;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.PEConnectionPoint;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.StringList;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.TypeID;
import com.filenet.api.constants.VersionStatus;
import com.filenet.api.core.CmTask;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.events.Subscription;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import filenet.pe.ce.casehandlers.StepElementData;
import filenet.pe.ce.casehandlers.StepElementDataEx;
import filenet.pe.ce.casehandlers.TypeValue;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWBootstrapURL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseWorkflowLauncher {
    private static final String LOCAL_CEURI = "/FileNet/Local/Engine";
    static final String m_classname = "CaseWorkflowLauncher";
    private Logger logger = Logger.getLogger("filenet.pe.ce.casehandlers");
    protected static final String FIELD_CASE_FOLDER = "F_CaseFolder";
    protected static final String FIELD_CASE_TASK = "F_CaseTask";
    protected static final String FIELD_COMMENT = "F_Comment";
    protected static final String FIELD_MAIN_ATTACHMENT = "F_MAINATTACHMENT";
    protected static final String FIELD_SUBJECT = "F_Subject";
    protected static final String FIELD_TEXT = "F_Text";
    protected static final String FIELD_WORKOBJECT_NUMBER = "F_WobNum";
    protected static final String FIELD_WORKFLOW_NAME = "F_WorkflowName";
    private static final String TASK_WORKFLOW_NAME = "CmAcmWorkflowName";
    private static final String TASK_WORKFLOW_CONNECTION_POINT = "CmAcmWorkflowConnectionPoint";
    private static final String TASK_WORKFLOW_PARAMETERS = "CmAcmWorkflowParameters";
    private static final String TASK_CUSTOM_OBJECT_PROPERTY_MAP = "CmAcmPropertyMap";
    private String[] m_launchFields = null;
    private Object[] m_launchValues = null;
    private Folder m_caseFolder = null;
    private CmTask m_task = null;
    private String m_workflowName = null;
    private String m_connectionPointName = null;
    private VWSession m_vwSession = null;
    private VWWorkflowSignature m_vwWorkflowSignature = null;

    public void autoLaunch(CmTask task, String workflowName, String connectionPointName) throws Exception {
        String method = "autoLaunch";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter autoLaunch(CmTask task, String workflowName, String connectionPointName)...");
        }
        this.m_task = task;
        this.m_workflowName = workflowName;
        this.m_connectionPointName = connectionPointName;
        this.m_caseFolder = (Folder)this.m_task.get_Coordinator();
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Done initializing member variables...");
        }
        String vwBootstrapURL = new VWBootstrapURL(LOCAL_CEURI, this.m_connectionPointName).toString();
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "[2]VWBootstrapURL = " + vwBootstrapURL);
        }
        this.m_vwSession = this.getVWSession(vwBootstrapURL);
        this.m_vwWorkflowSignature = this.m_vwSession.fetchWorkflowSignature(this.m_workflowName);
        this.processAutoLaunch(null);
    }

    public void autoLaunch(CmTask task, Subscription cmSubscription) throws Exception {
        String method = "autoLaunch";
        String workflowName = null;
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter autoLaunch(CmTask task, Subscription cmSubscription)...");
        }
        PropertyFilter TASK_WF_PF = new PropertyFilter();
        TASK_WF_PF.addIncludeProperty(1, null, null, TASK_WORKFLOW_NAME, null);
        TASK_WF_PF.addIncludeProperty(1, null, null, TASK_WORKFLOW_CONNECTION_POINT, null);
        TASK_WF_PF.addIncludeProperty(5, null, null, "Name", null);
        cmSubscription.refresh(TASK_WF_PF);
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "About to get TASK_WORKFLOW_NAME");
        }
        workflowName = cmSubscription.getProperties().getStringValue(TASK_WORKFLOW_NAME);
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Got TASK_WORKFLOW_NAME: " + workflowName);
        }
        PEConnectionPoint workflowConnectionPoint = (PEConnectionPoint)cmSubscription.getProperties().getObjectValue(TASK_WORKFLOW_CONNECTION_POINT);
        workflowConnectionPoint.refresh(new String[]{"Name"});
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Got TASK_WORKFLOW_CONNECTION_POINT: " + workflowConnectionPoint.get_Name());
        }
        if (workflowName != null && workflowName.length() > 0 && workflowConnectionPoint != null) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Proceeding with the auto launch...");
            }
        } else {
            throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.WorkflowNameOrConnectionPointNotValid", "Workflow name is empty or workflow connection point is null for Task with Id: " + task.get_Id());
        }
        this.m_task = task;
        this.m_caseFolder = (Folder)this.m_task.get_Coordinator();
        this.m_workflowName = workflowName;
        this.m_connectionPointName = workflowConnectionPoint.get_Name();
        String vwBootstrapURL = new VWBootstrapURL(LOCAL_CEURI, this.m_connectionPointName).toString();
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "[1]VWBootstrapURL = " + vwBootstrapURL);
        }
        this.m_vwSession = this.getVWSession(vwBootstrapURL);
        this.m_vwWorkflowSignature = this.m_vwSession.fetchWorkflowSignature(this.m_workflowName);
        StringList list = this.getFileMappingFromTask(this.m_task);
        if (list == null || list != null && list.isEmpty()) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "property map from Task is null or empty, process the old way...");
            }
            this.processAutoLaunch(null);
            return;
        }
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "property map from Task is not empty...");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String sPairs = (String)i.next();
                this.logger.finest("list[" + i + "] = " + sPairs);
            }
        }
        this.processAutoLaunch(list);
    }

    public VWStepElement getLaunchStep(Folder folder, String workflowName, VWSession session) throws Exception {
        String method = "getLaunchStep";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter getLaunchStep(com.filenet.api.core.Folder folder, String workflowName, VWSession session)...");
        }
        this.m_caseFolder = folder;
        this.m_workflowName = workflowName;
        this.m_vwSession = session;
        this.m_task = null;
        return this.processGetLaunchStep(null, null);
    }

    public StepElementDataEx getLaunchStepDataEx(Folder folder, String workflowName, VWSession session) throws Exception {
        String method = "getLaunchStepDataEx";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter getLaunchStep(com.filenet.api.core.Folder folder, String workflowName, VWSession session)...");
        }
        return this.getLaunchStepDataEx(folder, null, workflowName, session);
    }

    public VWStepElement getLaunchStep(Folder folder, CustomObject co, String workflowName, VWSession session) throws Exception {
        String method = "getLaunchStep";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter getLaunchStep(com.filenet.api.core.Folder folder, com.filenet.api.core.CustomObject co, String workflowName, VWSession session)...");
        }
        this.m_caseFolder = folder;
        this.m_workflowName = workflowName;
        this.m_vwSession = session;
        this.m_task = null;
        VWStepElement step = null;
        if (co == null) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "custom object is null, invoke the old way...");
            }
            step = this.processGetLaunchStep(null, null);
            return step;
        }
        StringList list = this.getFileMappingFromCustomObject(co);
        if (list == null || list != null && list.isEmpty()) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "property map from the custom object is null or empty...");
            }
            step = this.processGetLaunchStep(null, null);
            return step;
        }
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "property map from Task is not empty...");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String sPairs = (String)i.next();
                this.logger.finest("list[" + i + "] = " + sPairs);
            }
        }
        step = this.processGetLaunchStep(null, list);
        return step;
    }

    public StepElementDataEx getLaunchStepDataEx(Folder folder, CustomObject co, String workflowName, VWSession session) throws Exception {
        String method = "getLaunchStepDataEx";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter getLaunchStepDataEx(com.filenet.api.core.Folder folder, com.filenet.api.core.CustomObject co, String workflowName, VWSession session)...");
        }
        this.m_caseFolder = folder;
        this.m_workflowName = workflowName;
        this.m_vwSession = session;
        this.m_task = null;
        StringList list = null;
        if (co == null) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "custom object is null, invoke the old way...");
            }
        } else {
            list = this.getFileMappingFromCustomObject(co);
            if (list == null || list.isEmpty()) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property map from the custom object is null or empty...");
                }
            } else if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "property map from Task is not empty...");
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    String sPairs = (String)i.next();
                    this.logger.finest("list[" + i + "] = " + sPairs);
                }
            }
        }
        return new StepElementDataEx(this.processGetLaunchStepEx(list));
    }

    public void manualLaunch(CmTask task, StepElementData step, VWSession session) throws Exception {
        String method = "manualLaunch";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter manualLaunch(com.filenet.api.core.CmTask task, StepElementData step, VWSession session)...");
        }
        this.m_task = task;
        this.m_vwSession = session;
        this.m_caseFolder = (Folder)this.m_task.get_Coordinator();
        StringList list = this.getFileMappingFromTask(this.m_task);
        if (list == null || list != null && list.isEmpty()) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "property map from Task is null or empty, process the old way...");
            }
            this.processManualLaunch(step, null);
            return;
        }
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "property map from Task is not empty...");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String sPairs = (String)i.next();
                this.logger.finest("list[" + i + "] = " + sPairs);
            }
        }
        this.processManualLaunch(step, list);
    }

    public void manualLaunchEx(CmTask task, StepElementDataEx launchStepDataEx, VWSession session) throws Exception {
        String method = "manualLaunchEx";
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Enter manualLaunchEx(com.filenet.api.core.CmTask task, StepElementDataEx step, VWSession session)...");
        }
        this.m_task = task;
        this.m_vwSession = session;
        this.m_caseFolder = (Folder)this.m_task.get_Coordinator();
        StringList list = this.getFileMappingFromTask(this.m_task);
        if (list == null || list != null && list.isEmpty()) {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "property map from Task is null or empty, process the old way...");
            }
            this.processManualLaunchEx(launchStepDataEx, null);
            return;
        }
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "property map from Task is not empty...");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String sPairs = (String)i.next();
                this.logger.finest("list[" + i + "] = " + sPairs);
            }
        }
        this.processManualLaunchEx(launchStepDataEx, list);
    }

    private void processAutoLaunch(StringList list) throws Exception {
        String method = "processAutoLaunch";
        Hashtable<String, Object> mappingTable = null;
        try {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "PropertyMappingTable:" + (list == null ? "null" : "not null"));
            }
            mappingTable = list != null ? this.getMatchedFieldsFromMappingList(list) : this.getMatchedFieldsFromCaseProps();
            this.constructInitialValuesForAutoLaunch(mappingTable);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "About to call the API createLiveWorkObject()....");
                if (this.m_launchFields != null && this.m_launchValues != null) {
                    this.logger.finest(m_classname, method, "Launching fields/values:");
                    for (int i = 0; i < this.m_launchFields.length; ++i) {
                        this.valuesLogging(this.m_launchFields[i], this.m_launchValues[i]);
                    }
                }
            }
            VWCreateLiveWOResult[] result = null;
            result = this.m_vwSession.createLiveWorkObject(this.m_launchFields, this.m_launchValues, this.m_workflowName, 1);
            if (result != null && result[0].success()) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "createLiveWorkObject() succeeded for Case Task: {0}" + this.m_task.get_Id().toString());
                }
            } else {
                if (result != null) {
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "createLiveWorkObject() had failed for Case Task: " + this.m_task.get_Id().toString() + " with result: " + result[0].toString());
                    }
                    throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.WorkflowLaunchingFailWithResult", "createLiveWorkObject() for Case Task failed: {0} with result: {1}.", this.m_task.get_Id().toString(), result[0].toString());
                }
                if (result == null) {
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "createLiveWorkObject() had failed for Case Task: " + this.m_task.get_Id().toString() + " with result = null.");
                    }
                    throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.WorkflowLaunchingResultNull", "createLiveWorkObject() for Case Activity failed: {0} with a null result.", this.m_task.get_Id().toString());
                }
            }
        }
        catch (Exception t) {
            this.logger.error(m_classname, method, t);
            throw t;
        }
        finally {
            this.m_vwSession = null;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit processAutoLaunch()...");
            }
        }
    }

    private VWStepElement processGetLaunchStep(HashMap dataFieldsMap, StringList list) throws Exception {
        String method = "processGetLaunchStep";
        Hashtable<String, Object> mappingTable = null;
        try {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter processGetLaunchStep(HashMap dataFieldsMap, Hashtable propertyMap)...");
            }
            this.m_vwWorkflowSignature = this.m_vwSession.fetchWorkflowSignature(this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully fetching workflow signature for: " + this.m_workflowName);
            }
            if (list != null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is not null, it was constructed via getMatchedFieldsFromMappingList()...");
                }
                mappingTable = this.getMatchedFieldsFromMappingList(list);
            } else {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is null, call getMatchedFieldsFromCaseProps()...");
                }
                mappingTable = this.getMatchedFieldsFromCaseProps();
            }
            this.constructInitialValuesForAdhoc(dataFieldsMap, mappingTable);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "About to call the API createLaunchStepElement()....");
                if (this.m_launchFields != null && this.m_launchValues != null) {
                    this.logger.finest(m_classname, method, "Launching fields/values:");
                    for (int i = 0; i < this.m_launchFields.length; ++i) {
                        this.valuesLogging(this.m_launchFields[i], this.m_launchValues[i]);
                    }
                }
            }
            VWStepElement step = this.m_vwSession.createLaunchStepElement(this.m_launchFields, this.m_launchValues, this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully creating launching step element for: " + this.m_workflowName + ", F_WobNum: " + step.getWorkObjectNumber());
            }
            VWStepElement vWStepElement = step;
            return vWStepElement;
        }
        catch (Exception t) {
            this.logger.error(m_classname, method, t);
            throw t;
        }
        finally {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit processGetLaunchStep()...");
            }
        }
    }

    private VWStepElement processGetLaunchStepEx(StringList list) throws Exception {
        String method = "processGetLaunchStep";
        Hashtable<String, Object> mappingTable = null;
        try {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter processGetLaunchStep(HashMap dataFieldsMap, Hashtable propertyMap)...");
            }
            this.m_vwWorkflowSignature = this.m_vwSession.fetchWorkflowSignature(this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully fetching workflow signature for: " + this.m_workflowName);
            }
            if (list != null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is not null, it was constructed via getMatchedFieldsFromMappingList()...");
                }
                mappingTable = this.getMatchedFieldsFromMappingList(list);
            } else {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is null, call getMatchedFieldsFromCaseProps()...");
                }
                mappingTable = this.getMatchedFieldsFromCaseProps();
            }
            this.constructInitialValuesForAdhocEx(null, mappingTable);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "About to call the API createLaunchStepElement()....");
                if (this.m_launchFields != null && this.m_launchValues != null) {
                    this.logger.finest(m_classname, method, "Launching fields/values:");
                    for (int i = 0; i < this.m_launchFields.length; ++i) {
                        this.valuesLogging(this.m_launchFields[i], this.m_launchValues[i]);
                    }
                }
            }
            VWStepElement step = this.m_vwSession.createLaunchStepElement(this.m_launchFields, this.m_launchValues, this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully creating launching step element for: " + this.m_workflowName + ", F_WobNum: " + step.getWorkObjectNumber());
            }
            VWStepElement vWStepElement = step;
            return vWStepElement;
        }
        catch (Exception t) {
            this.logger.error(m_classname, method, t);
            throw t;
        }
        finally {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit processGetLaunchStep()...");
            }
        }
    }

    private void processManualLaunch(StepElementData launchStepData, StringList list) throws Exception {
        String method = "processManualLaunch";
        Hashtable<String, Object> mappingTable = null;
        try {
            String workclassKey;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter processManualLaunch(StepElementData launchStepData, Hashtable mappingTable)...");
            }
            if (launchStepData == null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The StepElementData object is null.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.NullStepElementData", "The StepElementData object is null.");
            }
            HashMap fieldsMap = launchStepData.getDataFieldsMap();
            if (fieldsMap == null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The workflow data fields collection (hashmap) is null.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.NullWorkflowFieldsHashMap", "The workflow data fields collection is null.");
            }
            if (this.logger.isFinest()) {
                Set entries = fieldsMap.entrySet();
                for (Map.Entry e : entries) {
                    String name = (String)e.getKey();
                    Object val = ((TypeValue)fieldsMap.get(name)).getValue();
                    if (val == null) {
                        this.logger.finest(m_classname, method, "hashmap name: " + name + ", value: null");
                        continue;
                    }
                    this.logger.finest(m_classname, method, "hashmap name: " + name + ", value: " + val.toString());
                }
            }
            if (!fieldsMap.containsKey(workclassKey = FIELD_WORKFLOW_NAME)) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The workflowName is not found in the workflow data fields collection.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.NoWorkClassName", "The F_WorkflowName is not found in the workflow data fields collection.");
            }
            this.m_workflowName = (String)((TypeValue)fieldsMap.get(workclassKey)).getValue();
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "StepElementData-F_WorkflowName: " + this.m_workflowName);
                String keyName = FIELD_WORKOBJECT_NUMBER;
                if (fieldsMap.containsKey(keyName)) {
                    String wobNum = (String)((TypeValue)fieldsMap.get(keyName)).getValue();
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "StepElementData-F_WobNum: " + wobNum);
                    }
                }
            }
            this.m_vwWorkflowSignature = this.m_vwSession.fetchWorkflowSignature(this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully fetching workflow signature for: " + this.m_workflowName);
            }
            if (list != null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is not null, it was constructed via getMatchedFieldsFromMappingList()...");
                }
                mappingTable = this.getMatchedFieldsFromMappingList(list);
            } else {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is null, call getMatchedFieldsFromCaseProps()...");
                }
                mappingTable = this.getMatchedFieldsFromCaseProps();
            }
            this.constructInitialValuesForAdhoc(fieldsMap, mappingTable);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "About to call the API createLaunchStepElement()....");
                if (this.m_launchFields != null && this.m_launchValues != null) {
                    this.logger.finest(m_classname, method, "Launching fields/values:");
                    for (int i = 0; i < this.m_launchFields.length; ++i) {
                        this.valuesLogging(this.m_launchFields[i], this.m_launchValues[i]);
                    }
                }
            }
            VWStepElement step = this.m_vwSession.createLaunchStepElement(this.m_launchFields, this.m_launchValues, this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully creating launching step element for: " + this.m_workflowName + " with F_WobNum: " + step.getWorkObjectNumber());
            }
            this.updateStepElementParameters(step, launchStepData);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully updating launching step element for: " + this.m_workflowName + " with F_WobNum: " + step.getWorkObjectNumber());
            }
            step.doDispatch();
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully dispatching launching step element for: " + this.m_workflowName + " with F_WobNum: " + step.getWorkObjectNumber());
            }
        }
        catch (Exception t) {
            this.logger.error(m_classname, method, t);
            throw t;
        }
        finally {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit processManualLaunch()...");
            }
        }
    }

    private void processManualLaunchEx(StepElementDataEx launchStepDataEx, StringList list) throws Exception {
        String method = "processManualLaunch";
        Hashtable<String, Object> mappingTable = null;
        try {
            String selectedResponse;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter processManualLaunch(StepElementData launchStepData, Hashtable mappingTable)...");
            }
            if (launchStepDataEx == null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The StepElementData object is null.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.NullStepElementData", "The StepElementData object is null.");
            }
            this.m_workflowName = launchStepDataEx.getWorkflowName();
            if (this.m_workflowName == null || this.m_workflowName.length() == 0) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The workflowName is not found in the workflow data fields collection.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.NoWorkClassName", "The field F_WorkflowName is not found in the workflow data fields collection.");
            }
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "StepElementData-F_WorkflowName: " + this.m_workflowName);
                String wobNum = launchStepDataEx.getWorkObjectNumber();
                this.logger.finest(m_classname, method, "StepElementData-F_WobNum: " + wobNum);
            }
            this.m_vwWorkflowSignature = this.m_vwSession.fetchWorkflowSignature(this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully retrieved workflow signature for: " + this.m_workflowName);
            }
            if (list != null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is not null, it was constructed via getMatchedFieldsFromMappingList()...");
                }
                mappingTable = this.getMatchedFieldsFromMappingList(list);
            } else {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "property mapping table is null, call getMatchedFieldsFromCaseProps()...");
                }
                mappingTable = this.getMatchedFieldsFromCaseProps();
            }
            this.constructInitialValuesForAdhocEx(launchStepDataEx, mappingTable);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "About to call the API createLaunchStepElement()....");
                if (this.m_launchFields != null && this.m_launchValues != null) {
                    this.logger.finest(m_classname, method, "Launching fields/values:");
                    for (int i = 0; i < this.m_launchFields.length; ++i) {
                        this.valuesLogging(this.m_launchFields[i], this.m_launchValues[i]);
                    }
                }
            }
            VWStepElement step = this.m_vwSession.createLaunchStepElement(this.m_launchFields, this.m_launchValues, this.m_workflowName);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully creating launching step element for: " + this.m_workflowName + " with F_WobNum: " + step.getWorkObjectNumber());
            }
            if ((selectedResponse = launchStepDataEx.getSelectedResponse()) != null) {
                step.setSelectedResponse(selectedResponse);
            }
            this.updateStepElementParametersEx(step, launchStepDataEx);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully updating launching step element for: " + this.m_workflowName + " with F_WobNum: " + step.getWorkObjectNumber());
            }
            step.doDispatch();
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Successfully dispatching launching step element for: " + this.m_workflowName + " with F_WobNum: " + step.getWorkObjectNumber());
            }
        }
        catch (Exception t) {
            this.logger.error(m_classname, method, t);
            throw t;
        }
        finally {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit processManualLaunch()...");
            }
        }
    }

    private void constructInitialValuesForAutoLaunch(Hashtable mappingTable) throws Exception {
        String method = "constructInitialValuesForAutoLaunch";
        Vector<String> vNames = new Vector<String>(5);
        Vector<Object> vValues = new Vector<Object>(5);
        if (this.m_task != null) {
            this.m_task.refresh((PropertyFilter)null);
        }
        try {
            Enumeration keys;
            VWFieldDefinition subjectFieldDef;
            VWFieldDefinition activityFieldDef;
            VWFieldDefinition folderFieldDef;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter constructInitialValuesForAutoLaunch()...");
            }
            StringBuffer f_text = new StringBuffer("This workflow is launched ");
            f_text.append("on Task (guid = ");
            f_text.append(this.m_task.get_Id());
            f_text.append(")");
            vNames.addElement(FIELD_TEXT);
            vValues.addElement(f_text.toString());
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "F_Text = " + f_text.toString());
            }
            Document doc = this.getInitiatingDocument();
            ObjectStore objStore = this.m_task.getObjectStore();
            if (doc != null) {
                String objStoreName;
                String sourceString = null;
                if (doc.get_ClassDescription().describedIsOfClass("CmAcmCM8ProxyDocument").booleanValue()) {
                    sourceString = this.documentCM8String(doc, objStore);
                }
                objStore.refresh(new String[]{"Name"});
                if (objStore != null && (objStoreName = objStore.get_Name()) != null) {
                    sourceString = this.documentString(doc, objStoreName);
                }
                if (sourceString != null && sourceString.length() > 0) {
                    vNames.addElement(FIELD_MAIN_ATTACHMENT);
                    vValues.addElement(sourceString);
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "F_MAINATTACHMENT = " + sourceString);
                    }
                }
            }
            if ((folderFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_CASE_FOLDER)) != null) {
                String caseFolderId = null;
                Id id = this.m_caseFolder.get_Id();
                if (id != null) {
                    caseFolderId = id.toString();
                }
                vNames.addElement(FIELD_CASE_FOLDER);
                vValues.addElement(new VWGuid(caseFolderId));
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "folder id: " + caseFolderId);
                }
            }
            if ((activityFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_CASE_TASK)) != null) {
                String caseActivityId = null;
                Id id = this.m_task.get_Id();
                if (id != null) {
                    caseActivityId = id.toString();
                }
                vNames.addElement(FIELD_CASE_TASK);
                vValues.addElement(new VWGuid(caseActivityId));
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "Task id: " + caseActivityId);
                }
            }
            if ((subjectFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_SUBJECT)) != null) {
                String activityName;
                String subject = subjectFieldDef.getStringValue();
                if (subject != null && subject.length() >= 2) {
                    subject = subject.substring(1, subject.length() - 1);
                }
                if ((subject == null || subject.trim().length() == 0) && this.m_task != null && (activityName = this.m_task.get_Name()) != null && activityName.trim().length() != 0) {
                    vNames.addElement(FIELD_SUBJECT);
                    vValues.addElement(activityName);
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "Setting F_Subject using the Task name: " + activityName);
                    }
                }
            }
            if (mappingTable != null && (keys = mappingTable.keys()) != null) {
                while (keys.hasMoreElements()) {
                    String keyName = (String)keys.nextElement();
                    Object value = mappingTable.get(keyName);
                    if (keyName == null) continue;
                    vNames.addElement(keyName);
                    vValues.addElement(value);
                    if (!this.logger.isFinest()) continue;
                    this.logger.finest(m_classname, method, "Using the match set, adding the following field to launched field/value... ");
                    this.valuesLogging(keyName, value);
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            this.logger.error(m_classname, method, e);
            throw e;
        }
        this.m_launchFields = new String[vNames.size()];
        vNames.copyInto(this.m_launchFields);
        this.m_launchValues = new Object[vValues.size()];
        vValues.copyInto(this.m_launchValues);
    }

    private void constructInitialValuesForAdhoc(HashMap dataFieldsMapData, Hashtable mappingTable) throws Exception {
        String method = "constructInitialValuesForAdhoc";
        Vector<String> vNames = new Vector<String>(5);
        Vector<Object> vValues = new Vector<Object>(5);
        try {
            Enumeration keys;
            Id id;
            VWFieldDefinition folderFieldDef;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter constructInitialValuesForAdhoc()...");
            }
            if (this.m_caseFolder != null) {
                this.m_caseFolder.refresh((PropertyFilter)null);
            }
            if (this.m_task != null) {
                this.m_task.refresh((PropertyFilter)null);
            }
            if (dataFieldsMapData != null) {
                String keyName = FIELD_WORKOBJECT_NUMBER;
                if (dataFieldsMapData.containsKey(keyName)) {
                    String wobNum = (String)((TypeValue)dataFieldsMapData.get(keyName)).getValue();
                    vNames.addElement("~F_WobNum");
                    vValues.addElement(wobNum);
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "updating field: " + keyName + " value: " + wobNum);
                    }
                } else {
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "The F_WobNum is not found in the workflow data fields collection.");
                    }
                    throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.nowobnum", "The F_WobNum is not found in the workflow data fields collection.");
                }
                keyName = "F_Responses";
                if (dataFieldsMapData.containsKey(keyName)) {
                    Integer[] responses = (Integer[])((TypeValue)dataFieldsMapData.get(keyName)).getValue();
                    vNames.addElement(keyName);
                    vValues.addElement(responses);
                }
                if (dataFieldsMapData.containsKey(keyName = FIELD_SUBJECT)) {
                    String subject = (String)((TypeValue)dataFieldsMapData.get(keyName)).getValue();
                    if (subject == null || subject.trim().length() == 0) {
                        String activityName;
                        if (this.m_task != null && (activityName = this.m_task.get_Name()) != null && activityName.trim().length() != 0) {
                            vNames.addElement(keyName);
                            vValues.addElement(activityName);
                            if (this.logger.isFinest()) {
                                this.logger.finest(m_classname, method, "Setting F_Subject using the Task name: " + activityName);
                            }
                        }
                    } else {
                        vNames.addElement(keyName);
                        vValues.addElement(subject);
                    }
                }
                if (dataFieldsMapData.containsKey(keyName = FIELD_COMMENT)) {
                    String comment = (String)((TypeValue)dataFieldsMapData.get(keyName)).getValue();
                    vNames.addElement(keyName);
                    vValues.addElement(comment);
                }
            }
            if (this.m_caseFolder != null && (folderFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_CASE_FOLDER)) != null) {
                String caseFolderId = null;
                id = this.m_caseFolder.get_Id();
                if (id != null) {
                    caseFolderId = id.toString();
                }
                vNames.addElement(FIELD_CASE_FOLDER);
                vValues.addElement(new VWGuid(caseFolderId));
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "folder id: " + caseFolderId);
                }
            }
            if (this.m_task != null) {
                VWFieldDefinition activityFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_CASE_TASK);
                if (activityFieldDef != null) {
                    String caseActivityId = null;
                    id = this.m_task.get_Id();
                    if (id != null) {
                        caseActivityId = id.toString();
                    }
                    vNames.addElement(FIELD_CASE_TASK);
                    vValues.addElement(new VWGuid(caseActivityId));
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "Task id: " + caseActivityId);
                    }
                }
                StringBuffer f_text = new StringBuffer("This workflow is launched ");
                f_text.append("on Task (guid = ");
                f_text.append(this.m_task.get_Id());
                f_text.append(")");
                vNames.addElement(FIELD_TEXT);
                vValues.addElement(f_text.toString());
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "F_Text = " + f_text.toString());
                }
            }
            if (mappingTable != null && (keys = mappingTable.keys()) != null) {
                while (keys.hasMoreElements()) {
                    String keyName = (String)keys.nextElement();
                    Object value = mappingTable.get(keyName);
                    if (keyName == null) continue;
                    vNames.addElement(keyName);
                    vValues.addElement(value);
                    if (!this.logger.isFinest()) continue;
                    this.logger.finest(m_classname, method, "Using the match set, adding the following field to launch field/value... ");
                    this.valuesLogging(keyName, value);
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            this.logger.error(m_classname, method, e);
            throw e;
        }
        this.m_launchFields = new String[vNames.size()];
        vNames.copyInto(this.m_launchFields);
        this.m_launchValues = new Object[vValues.size()];
        vValues.copyInto(this.m_launchValues);
    }

    private void constructInitialValuesForAdhocEx(StepElementDataEx launchStepDataEx, Hashtable mappingTable) throws Exception {
        String method = "constructInitialValuesForAdhoc";
        Vector<String> vNames = new Vector<String>();
        Vector<Object> vValues = new Vector<Object>();
        try {
            Enumeration keys;
            Id id;
            VWFieldDefinition folderFieldDef;
            PropertyFilter pf;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter constructInitialValuesForAdhoc()...");
            }
            if (this.m_caseFolder != null) {
                pf = null;
                this.m_caseFolder.refresh(pf);
            }
            if (this.m_task != null) {
                pf = null;
                this.m_task.refresh(pf);
            }
            if (launchStepDataEx != null) {
                String comment;
                String wobNum = launchStepDataEx.getWorkObjectNumber();
                if (wobNum != null && wobNum.length() > 0) {
                    vNames.addElement("~F_WobNum");
                    vValues.addElement(wobNum);
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "updating field: F_WobNum value: " + wobNum);
                    }
                } else {
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "The F_WobNum is not found in the workflow data fields collection.");
                    }
                    throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.nowobnum", "The F_WobNum is not found in the workflow data fields collection.");
                }
                String subject = launchStepDataEx.getSubject();
                if (subject == null || subject.trim().length() == 0) {
                    String activityName;
                    if (this.m_task != null && (activityName = this.m_task.get_Name()) != null && activityName.trim().length() != 0) {
                        vNames.addElement(FIELD_SUBJECT);
                        vValues.addElement(activityName);
                        if (this.logger.isFinest()) {
                            this.logger.finest(m_classname, method, "Setting F_Subject using the Task name: " + activityName);
                        }
                    }
                } else {
                    vNames.addElement(FIELD_SUBJECT);
                    vValues.addElement(subject);
                }
                if ((comment = launchStepDataEx.getComment()) != null && comment.length() > 0) {
                    vNames.addElement(FIELD_COMMENT);
                    vValues.addElement(comment);
                }
            }
            if (this.m_caseFolder != null && (folderFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_CASE_FOLDER)) != null) {
                String caseFolderId = null;
                id = this.m_caseFolder.get_Id();
                if (id != null) {
                    caseFolderId = id.toString();
                }
                vNames.addElement(FIELD_CASE_FOLDER);
                vValues.addElement(new VWGuid(caseFolderId));
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "folder id: " + caseFolderId);
                }
            }
            if (this.m_task != null) {
                VWFieldDefinition activityFieldDef = (VWFieldDefinition)this.m_vwWorkflowSignature.getField(FIELD_CASE_TASK);
                if (activityFieldDef != null) {
                    String caseActivityId = null;
                    id = this.m_task.get_Id();
                    if (id != null) {
                        caseActivityId = id.toString();
                    }
                    vNames.addElement(FIELD_CASE_TASK);
                    vValues.addElement(new VWGuid(caseActivityId));
                    if (this.logger.isFinest()) {
                        this.logger.finest(m_classname, method, "Task id: " + caseActivityId);
                    }
                }
                StringBuffer f_text = new StringBuffer("This workflow is launched ");
                f_text.append("on Task (guid = ");
                f_text.append(this.m_task.get_Id());
                f_text.append(")");
                vNames.addElement(FIELD_TEXT);
                vValues.addElement(f_text.toString());
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "F_Text = " + f_text.toString());
                }
            }
            if (mappingTable != null && (keys = mappingTable.keys()) != null) {
                while (keys.hasMoreElements()) {
                    String keyName = (String)keys.nextElement();
                    Object value = mappingTable.get(keyName);
                    if (keyName == null) continue;
                    vNames.addElement(keyName);
                    vValues.addElement(value);
                    if (!this.logger.isFinest()) continue;
                    this.logger.finest(m_classname, method, "Using the match set, adding the following field to launch field/value... ");
                    this.valuesLogging(keyName, value);
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            this.logger.error(m_classname, method, e);
            throw e;
        }
        this.m_launchFields = new String[vNames.size()];
        vNames.copyInto(this.m_launchFields);
        this.m_launchValues = new Object[vValues.size()];
        vValues.copyInto(this.m_launchValues);
    }

    private void updateStepElementParameters(VWStepElement stepElement, StepElementData stepData) throws Exception {
        String method = "updateStepElementParameters";
        try {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter updateStepElementParameters()...");
            }
            String[] parameterNames = stepData.getParameterNames();
            Object[] parameterValues = stepData.getParameterValues(parameterNames);
            if (parameterNames == null || parameterValues == null) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The parameter names array or the parameter values array is null.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.parameterArraysNull", "The parameter names array or the parameter values array cannot be null.");
            }
            if (parameterNames.length != parameterValues.length) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "The length of the parameter names array and the length of the parameter values array are not the same.");
                }
                throw new VWException("filenet.pe.ce.casehandlers.CaseWorkflowLauncher.parameterArraysNotSameLength", "The length of the parameter names array and the length of the parameter values array must be the same.");
            }
            for (int i = 0; i < parameterNames.length; ++i) {
                int mode = stepElement.getParameter(parameterNames[i]).getMode();
                if (mode != 2 && mode != 3) continue;
                stepElement.setParameterValue(parameterNames[i], parameterValues[i], false);
                if (!this.logger.isFinest()) continue;
                this.paramsLogging(stepElement, parameterNames[i], parameterValues[i]);
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            this.logger.error(m_classname, method, e);
            throw e;
        }
        finally {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit updateStepElementParameters()...");
            }
        }
    }

    private void updateStepElementParametersEx(VWStepElement stepElement, StepElementDataEx launchStepDataEx) throws Exception {
        String method = "updateStepElementParameters";
        try {
            StepElementDataEx.StepElementParameter[] stepParameters;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Enter updateStepElementParameters()...");
            }
            if ((stepParameters = launchStepDataEx.getParameters()) != null) {
                for (int i = 0; i < stepParameters.length; ++i) {
                    int mode;
                    VWParameter vwParameter;
                    StepElementDataEx.StepElementParameter stepParameter = stepParameters[i];
                    if (stepParameter == null || (vwParameter = stepElement.getParameter(stepParameter.getName())) == null || (mode = vwParameter.getMode()) != 2 && mode != 3) continue;
                    stepElement.setParameterValue(stepParameter.getName(), stepParameter.getValue(), false);
                    if (!this.logger.isFinest()) continue;
                    this.paramsLogging(stepElement, stepParameter.getName(), stepParameter.getValue());
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            this.logger.error(m_classname, method, e);
            throw e;
        }
        finally {
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Exit updateStepElementParameters()...");
            }
        }
    }

    private VWSession getVWSession(String vwBootstrapURL) throws VWException {
        return new VWSession(vwBootstrapURL);
    }

    private Document getInitiatingDocument() throws Exception {
        Document initiatingDocument = null;
        if (this.m_task.getProperties().isPropertyPresent("CmAcmTriggerDocument")) {
            initiatingDocument = (Document)this.m_task.getProperties().getObjectValue("CmAcmTriggerDocument");
        }
        if (initiatingDocument == null && this.m_task.getProperties().isPropertyPresent("CmAcmInitiatingDocument")) {
            initiatingDocument = (Document)this.m_task.getProperties().getObjectValue("CmAcmInitiatingDocument");
        }
        return initiatingDocument;
    }

    private Properties getCaseProperties() throws Exception {
        String method = "getCaseProperties";
        Properties props = null;
        try {
            if (this.m_caseFolder != null) {
                props = this.m_caseFolder.getProperties();
            }
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.API_PROPERTY_NOT_IN_CACHE) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "API_PROPERTY_NOT_IN_CACHE: errors in getting properties for Case Folder.");
                }
                return null;
            }
            this.logger.error(m_classname, method, e);
            throw e;
        }
        return props;
    }

    private Hashtable<String, Object> getMatchedFieldsFromCaseProps() throws Exception {
        String method = "getMatchedFields";
        VWFieldDefinition[] fieldDefs = null;
        Hashtable<String, Object> launchFieldsTable = new Hashtable<String, Object>();
        Properties props = this.getCaseProperties();
        if (props == null) {
            return launchFieldsTable;
        }
        fieldDefs = this.m_vwWorkflowSignature.getFieldDefinitions();
        if (fieldDefs == null) {
            return launchFieldsTable;
        }
        for (int i = 0; i < fieldDefs.length; ++i) {
            String fieldName = fieldDefs[i].getName();
            int fieldType = fieldDefs[i].getFieldType();
            if (!props.isPropertyPresent(fieldName)) continue;
            ClassDescription cd = this.m_caseFolder.get_ClassDescription();
            PropertyDescriptionList pSet = cd.get_PropertyDescriptions();
            Iterator itp = pSet.iterator();
            Cardinality cardinality = null;
            TypeID tid = null;
            boolean foundProperty = false;
            while (itp.hasNext()) {
                PropertyDescription pd = (PropertyDescription)itp.next();
                pd.getProperties();
                cardinality = pd.get_Cardinality();
                if (cardinality != Cardinality.SINGLE && cardinality != Cardinality.LIST) continue;
                try {
                    if (pd.get_SymbolicName().compareTo(fieldName) != 0) continue;
                    tid = pd.get_DataType();
                    if (!(tid == TypeID.BOOLEAN && fieldType == 4 || tid == TypeID.LONG && fieldType == 1 || tid == TypeID.DATE && fieldType == 16 || tid == TypeID.STRING && fieldType == 2) && (tid != TypeID.DOUBLE || fieldType != 8)) break;
                    foundProperty = true;
                    break;
                }
                catch (EngineRuntimeException e) {
                    if (e.getExceptionCode() != ExceptionCode.API_PROPERTY_NOT_IN_CACHE || !this.logger.isFinest()) continue;
                    this.logger.finest(m_classname, method, "API_PROPERTY_NOT_IN_CACHE: errors in getting symbolic name for this PropertyDescription: " + pd.get_Name());
                }
            }
            if (!foundProperty) continue;
            Object val = this.getPropertyValue(props, fieldName, cardinality);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "found matched property: " + fieldName + ", type: " + tid.getValue());
                this.valuesLogging(fieldName, val);
            }
            if (val == null || val instanceof Object[] && ((Object[])val).length == 0) continue;
            launchFieldsTable.put(fieldName, val);
        }
        return launchFieldsTable;
    }

    private Object getPropertyValue(Properties props, String propName, Cardinality cardinality) {
        String method = "getPropertyValue";
        if (cardinality.equals(Cardinality.LIST)) {
            List objList = (List)props.getObjectValue(propName);
            return objList.toArray();
        }
        if (cardinality.equals(Cardinality.SINGLE)) {
            Object propertyValue = null;
            propertyValue = props.getObjectValue(propName);
            return propertyValue;
        }
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "The cardinality of property is not supported in property mapping: " + propName);
        }
        return null;
    }

    private String documentString(Document doc, String objStoreName) throws Exception {
        String method = "documentString";
        StringBuffer docSB = new StringBuffer();
        String docName = "";
        try {
            docName = doc.get_Name();
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.API_PROPERTY_NOT_IN_CACHE) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "API_PROPERTY_NOT_IN_CACHE for NAME, leave it empty");
                }
            }
            this.logger.error(m_classname, method, e);
        }
        docSB.append(docName + "||3|3|" + objStoreName + "|");
        if (doc.get_IsCurrentVersion().booleanValue()) {
            docSB.append(doc.get_VersionSeries().get_Id());
        } else if (doc.get_VersionStatus() == VersionStatus.RELEASED) {
            docSB.append(doc.get_VersionSeries().get_Id() + "|-1");
        } else {
            PropertyFilter ID_PF = new PropertyFilter();
            ID_PF.addIncludeProperty(0, null, null, "Id", null);
            VersionSeries vs = doc.get_VersionSeries();
            vs.fetchProperties(ID_PF);
            docSB.append(vs.get_Id() + "|" + doc.get_Id());
        }
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "got initiating document: " + docSB.toString());
        }
        return docSB.toString();
    }

    private String documentCM8String(Document doc, ObjectStore objStore) throws Exception {
        String method = "documentCM8String";
        StringBuffer docSB = new StringBuffer();
        String docName = "";
        try {
            docName = doc.get_Name();
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.API_PROPERTY_NOT_IN_CACHE) {
                if (this.logger.isFinest()) {
                    this.logger.finest(m_classname, method, "API_PROPERTY_NOT_IN_CACHE for NAME, leave it empty");
                }
            }
            this.logger.error(m_classname, method, e);
        }
        String libName = this.getCM8LibraryName(objStore);
        docSB.append(docName + "||3|4|" + libName + "|");
        docSB.append(doc.getProperties().getStringValue("CmAcmPID"));
        if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "got initiating document: " + docSB.toString());
        }
        return docSB.toString();
    }

    private void paramsLogging(VWStepElement stepElement, String paramName, Object paramVal) {
        String method = "paramsLogging";
        if (paramVal == null) {
            this.logger.finest(m_classname, method, paramName + " value: null");
            return;
        }
        if (paramVal instanceof Object[] && ((Object[])paramVal).length == 0) {
            this.logger.finest(m_classname, method, paramName + " value: empty array");
            return;
        }
        boolean bArray = false;
        try {
            bArray = stepElement.getParameter(paramName).isArray();
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        if (!bArray) {
            this.logger.finest(m_classname, method, "updating param: " + paramName + " value: " + paramVal.toString());
            return;
        }
        Object value = paramVal;
        if (value instanceof VWAttachment[]) {
            VWAttachment[] theArray = null;
            theArray = (VWAttachment[])value;
            for (int i = 0; i < theArray.length; ++i) {
                VWAttachment anAttachment = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + anAttachment.toString());
            }
        } else if (value instanceof VWParticipant[]) {
            VWParticipant[] theArray = null;
            theArray = (VWParticipant[])value;
            for (int i = 0; i < theArray.length; ++i) {
                VWParticipant aParticipant = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + aParticipant.toString());
            }
        } else if (value instanceof Integer[]) {
            Integer[] theArray = null;
            theArray = (Integer[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Integer anInt = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + anInt.toString());
            }
        } else if (value instanceof Date[]) {
            Date[] theArray = null;
            theArray = (Date[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Date aDate = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + aDate.toString());
            }
        } else if (value instanceof String[]) {
            String[] theArray = null;
            theArray = (String[])value;
            for (int i = 0; i < theArray.length; ++i) {
                String aString = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + aString.toString());
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] theArray = null;
            theArray = (Boolean[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Boolean aBoolean = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + aBoolean.toString());
            }
        } else if (value instanceof Double[]) {
            Double[] theArray = null;
            theArray = (Double[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Double aDouble = theArray[i];
                this.logger.finest(m_classname, method, "updating " + paramName + "[" + i + "]" + ", value: " + aDouble.toString());
            }
        } else {
            this.logger.finest(m_classname, method, "updating param: " + paramName + " value: " + paramVal.toString());
        }
    }

    private void valuesLogging(String objName, Object objValue) {
        String method = "valuesLogging";
        if (objValue == null) {
            this.logger.finest(m_classname, method, objName + " value: null");
            return;
        }
        if (objValue instanceof Object[] && ((Object[])objValue).length == 0) {
            this.logger.finest(m_classname, method, objName + " value: empty array");
            return;
        }
        Object value = objValue;
        if (value instanceof VWAttachment[]) {
            VWAttachment[] theArray = null;
            theArray = (VWAttachment[])value;
            for (int i = 0; i < theArray.length; ++i) {
                VWAttachment anAttachment = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + anAttachment.toString());
            }
        } else if (value instanceof VWParticipant[]) {
            VWParticipant[] theArray = null;
            theArray = (VWParticipant[])value;
            for (int i = 0; i < theArray.length; ++i) {
                VWParticipant aParticipant = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + aParticipant.toString());
            }
        } else if (value instanceof Integer[]) {
            Integer[] theArray = null;
            theArray = (Integer[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Integer anInt = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + anInt.toString());
            }
        } else if (value instanceof Date[]) {
            Date[] theArray = null;
            theArray = (Date[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Date aDate = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + aDate.toString());
            }
        } else if (value instanceof String[]) {
            String[] theArray = null;
            theArray = (String[])value;
            for (int i = 0; i < theArray.length; ++i) {
                String aString = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + aString.toString());
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] theArray = null;
            theArray = (Boolean[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Boolean aBoolean = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + aBoolean.toString());
            }
        } else if (value instanceof Double[]) {
            Double[] theArray = null;
            theArray = (Double[])value;
            for (int i = 0; i < theArray.length; ++i) {
                Double aDouble = theArray[i];
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + aDouble.toString());
            }
        } else if (value instanceof Object[]) {
            Object[] theArray = null;
            theArray = (Object[])value;
            for (int i = 0; i < theArray.length; ++i) {
                String aString = theArray[i].toString();
                this.logger.finest(m_classname, method, objName + "[" + i + "]" + ", value: " + aString.toString());
            }
        } else {
            this.logger.finest(m_classname, method, objName + " value: " + objValue.toString());
        }
    }

    private StringList getFileMappingFromTask(CmTask task) throws Exception {
        String method = "getFileMappingFromTask";
        StringList list = null;
        CustomObject co = null;
        task.refresh((PropertyFilter)null);
        if (task.getProperties().isPropertyPresent(TASK_WORKFLOW_PARAMETERS)) {
            co = (CustomObject)task.getProperties().getObjectValue(TASK_WORKFLOW_PARAMETERS);
            list = this.getFileMappingFromCustomObject(co);
        } else if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "The CmAcmWorkflowParameters property is not present for task (GUID): " + task.get_Id());
        }
        return list;
    }

    private StringList getFileMappingFromCustomObject(CustomObject co) throws Exception {
        String method = "getFileMappingFromCustomObject";
        StringList list = null;
        if (co != null) {
            co.refresh((PropertyFilter)null);
            list = co.getProperties().getStringListValue(TASK_CUSTOM_OBJECT_PROPERTY_MAP);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "Retrieved String List of File Mapping from the custom object");
            }
        } else if (this.logger.isFinest()) {
            this.logger.finest(m_classname, method, "Custom object is null.");
        }
        return list;
    }

    private Hashtable<String, Object> getMatchedFieldsFromMappingList(StringList list) throws Exception {
        String method = "getMatchedFieldsFromMappingList";
        Hashtable<String, Object> launchFieldsTable = new Hashtable<String, Object>();
        Properties props = this.getCaseProperties();
        if (props == null) {
            return launchFieldsTable;
        }
        for (String sPairs : list) {
            int nIndex;
            if (sPairs == null || sPairs.length() <= 0 || sPairs.compareTo("null") == 0) continue;
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "value from propertyMap StringList: " + sPairs);
            }
            if ((nIndex = sPairs.indexOf(61)) == -1) continue;
            String WFDataFieldName = sPairs.substring(0, nIndex).trim();
            String CESymbolicName = sPairs.substring(nIndex + 1);
            VWFieldDefinition WFFieldDef = this.m_vwWorkflowSignature.findField(WFDataFieldName);
            if (WFFieldDef == null) continue;
            int WFFieldType = WFFieldDef.getFieldType();
            if (!props.isPropertyPresent(CESymbolicName)) continue;
            ClassDescription cDescription = this.m_caseFolder.get_ClassDescription();
            PropertyDescriptionList pDescriptionList = cDescription.get_PropertyDescriptions();
            Iterator iterator = pDescriptionList.iterator();
            Cardinality cardinality = null;
            TypeID tid = null;
            boolean isTypeMatched = false;
            while (iterator.hasNext()) {
                PropertyDescription o = (PropertyDescription)iterator.next();
                if (!o.get_SymbolicName().equals(CESymbolicName)) continue;
                cardinality = o.get_Cardinality();
                tid = o.get_DataType();
                if (!(tid == TypeID.BOOLEAN && WFFieldType == 4 || tid == TypeID.LONG && WFFieldType == 1 || tid == TypeID.DATE && WFFieldType == 16 || tid == TypeID.STRING && WFFieldType == 2) && (tid != TypeID.DOUBLE || WFFieldType != 8)) break;
                isTypeMatched = true;
                break;
            }
            if (!isTypeMatched) continue;
            Object val = this.getPropertyValue(props, CESymbolicName, cardinality);
            if (this.logger.isFinest()) {
                this.logger.finest(m_classname, method, "found matched property: " + WFDataFieldName + ", type: " + tid.getValue());
                this.valuesLogging(WFDataFieldName, val);
            }
            if (val == null || val instanceof Object[] && ((Object[])val).length == 0) continue;
            launchFieldsTable.put(WFDataFieldName, val);
        }
        return launchFieldsTable;
    }

    public String getCM8LibraryName(ObjectStore objStore) throws Exception {
        String method = "getCM8LibraryName";
        CustomObject IntgData = null;
        ClassDefinition classDef = Factory.ClassDefinition.fetchInstance((ObjectStore)objStore, (String)"CmAcmCreateCM8CaseSubscription", null);
        PropertyDefinitionList pdl = classDef.get_PropertyDefinitions();
        for (PropertyDefinition pd : pdl) {
            String symName = pd.get_SymbolicName();
            if (symName.compareTo("CmAcmIntegrationData") != 0) continue;
            try {
                IntgData = (CustomObject)pd.getProperties().get("PropertyDefaultObject").getEngineObjectValue();
            }
            catch (Exception e) {}
            break;
        }
        if (IntgData == null) {
            String errMsg = "getCM8LibraryName(): Subscription's Integration Data Object is null";
            Exception error = new Exception(errMsg);
            this.logger.error(m_classname, method, error);
            throw error;
        }
        IntgData.refresh();
        return IntgData.getProperties().getStringValue("CmAcmLibraryName");
    }
}

